/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.dynpack;

import com.google.common.base.Stopwatch;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import xfacthd.buddingcrystals.common.util.CrystalLoader;

public abstract class BuddingPackResources
implements PackResources {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private final PackMetadataSection packMetadata;
    private final Map<ResourceLocation, String> dataCache = new HashMap<ResourceLocation, String>();
    private final PackType type;
    private final Set<String> namespaces;

    protected BuddingPackResources(PackType type, int packFormat) {
        this.type = type;
        this.packMetadata = new PackMetadataSection((Component)new TextComponent(this.m_8017_()), packFormat);
        String typeName = type == PackType.CLIENT_RESOURCES ? "resourcepack" : "datapack";
        LOGGER.info("Reloading crystal definitions for dynamic {} reload", (Object)typeName);
        Stopwatch stopwatch = Stopwatch.createStarted();
        CrystalLoader.updateFromJson(CrystalLoader.Update.fromPackType(type));
        stopwatch.stop();
        LOGGER.info("Reloaded crystal definitions in {}ms", (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        LOGGER.info("Generating dynamic {} for BuddingCrystals", (Object)typeName);
        stopwatch = Stopwatch.createStarted();
        this.buildResources(this.dataCache);
        this.namespaces = this.dataCache.keySet().stream().map(ResourceLocation::m_135827_).collect(Collectors.toSet());
        stopwatch.stop();
        LOGGER.info("Generated dynamic {} in {}ms", (Object)typeName, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public InputStream m_5542_(String fileName) {
        return null;
    }

    public final InputStream m_8031_(PackType type, ResourceLocation location) throws IOException {
        if (this.m_7211_(type, location)) {
            return new ByteArrayInputStream(this.dataCache.get(location).getBytes(StandardCharsets.UTF_8));
        }
        throw new IOException(String.format("Couldn't find resource %s in BuddingCrystals dynamic data pack", location));
    }

    public final Collection<ResourceLocation> m_7466_(PackType type, String namespace, String path, int maxDepth, Predicate<String> filter) {
        if (type == this.type) {
            int pathLen = path.length();
            return this.dataCache.keySet().stream().filter(loc -> loc.m_135827_().equals(namespace)).filter(loc -> loc.m_135815_().startsWith(path)).filter(loc -> filter.test(loc.toString())).filter(loc -> StringUtils.countMatches((CharSequence)loc.m_135815_().substring(pathLen), (char)'/') <= maxDepth).toList();
        }
        return Set.of();
    }

    public final boolean m_7211_(PackType type, ResourceLocation location) {
        if (type == this.type) {
            return this.dataCache.containsKey(location);
        }
        return false;
    }

    public final Set<String> m_5698_(PackType type) {
        return type == this.type ? this.namespaces : Set.of();
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        if (deserializer == PackMetadataSection.f_10366_) {
            return (T)this.packMetadata;
        }
        return null;
    }

    public void close() {
    }

    public final boolean isHidden() {
        return true;
    }

    protected abstract void buildResources(Map<ResourceLocation, String> var1);

    protected static ResourceLocation mcRl(String path) {
        return new ResourceLocation("minecraft", path);
    }

    protected static ResourceLocation bcRl(String path) {
        return new ResourceLocation("buddingcrystals", path);
    }
}

